/******************************************************************************
 * Technical University of Darmstadt
 * Industrial Process and System Communication
 * Project: TCP
 * Filename: FSMArrowPanel.java
 * Author: Gunter Weiss
 * Contents: places an arrow in a panel
 * Last Changes: Gunter Weiss 23/4/97
 *****************************************************************************/

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Color;

/******************************************************************************
* Class: FSMArrowPanel
* Description: places the Arrow in a panel
******************************************************************************/
public class FSMArrowPanel extends Panel {
  Image image;
  String statestring;
  int size,x1,x2,y1,y2;
  int dx,dy,dy2;
  int highlight;
  int direction;
  FSMWindow fsm_window;
  FSMArrowCan fsm_arrowcan;
  HTcpSegment seg;

  public FSMArrowPanel ( FSMWindow fsm_window, int d1, int hl){
    this.fsm_window=fsm_window;
    fsm_arrowcan = new FSMArrowCan(fsm_window, d1, hl);
    setBackground(Color.lightGray);
    setLayout( null );
    add(fsm_arrowcan);
    validate();
    show();
  }

/******************************************************************************
* Method: changeSize
* Description: scales the images and paints them
* Parameters: quality factor
* Return Value: none
******************************************************************************/
  public void changeSize( int size, int direction, int highlight, HTcpSegment seg){
    if (highlight == 0)setForeground(Color.black);
    if (highlight == 1)setForeground(Color.red);
    if (highlight == 2)setForeground(Color.yellow);
    repaint();
    fsm_arrowcan.changeSize(size,direction,seg);
    //repaint();
    validate();
  }
/******************************************************************************
* Method: changeSize
* Description: scales the arrows and paints them
* Parameters: screenfactor
* Return Value: none
******************************************************************************/
  public void changeSize( int size, int di ){
    this .size = size;
    this .direction = di;
    fsm_arrowcan.changeSize(size,di);
    if( size == 1 ){
      dx = 100;  //factor 1
      dy = 60;
      dy2 = 20;
    }
    else if( size == 2 ){
      dx = 120;  //factor 1,25
      dy = 72;
      dy2 = 24;
    }
    else if( size == 3 ){
      dx = 160;  //factor 1,6
      dy = 96;
      dy2 = 32;
    }
    else if( size == 4 ){
      dx = 200;  //factor 2
      dy = 120;
      dy2 = 40;
    }
    switch (direction) {
        case 1:
        case 2:
        case 3:
            resize(dx,dy);
            break;
        case 0:
        case 4:
        case 5:
        case 6:
            resize(dx,dy2);
            break;
    }
    repaint();
    validate();
  }
}












